/*

 Serial UART

*/

#include	<pic.h>
#include	<conio.h>
#include	<stdio.h>
#include    <string.h>
#include	"serial.h"
#include    "variable.h"
//Desactive les warnings du compilateur concernant conversion to shorter data type
#pragma warning disable 752
//Desactive les warnings du compilateur concernant les fonctions non utilise
#pragma warning disable 520

void serial_setup(void)
{
	/* relates crystal freq to baud rate - see above and PIC16F87x data sheet under 'USART async. modes'

	BRGH=1, Fosc=3.6864MHz		BRGH=1, Fosc=4MHz      BRGH=1, Fosc=8MHz    BRGH=1, Fosc=16MHz
	----------------------	  -----------------      -----------------    ------------------
	Baud		SPBRG             Baud		SPBRG          Baud		SPBRG         Baud		SPBRG
	1200		191               1200		207.3          1200		415.7         9600    103
	2400		95                2400		103.2          2400		207.3         19200		51
	4800		47                4800		51.1           4800		103.2         38400   25
	9600		23                9600		25.0           9600		51.1          57600   16
	19200		11                19200		12.0           19200	25.0          115200  8
	38400		5                 38400		5.5            38400	12.0
	57600		3                 57600		3.3            57600	7.7
	115200	1                 115200	1.2            115200	3.3

	*/

	/*
	 * Comms setup:
	 */

	#define BAUD 19200
	#define DIVIDER ((PIC_CLK/(16UL * BAUD) -1))
	#define HIGH_SPEED 1

	//you can comment these #assert statements out if you dont want error checking
	#if PIC_CLK==3686400 && BAUD==19200
		#assert DIVIDER==11
	#elif PIC_CLK==4000000 && BAUD==19200
		#assert DIVIDER==12
	#elif PIC_CLK==16000000 && BAUD==19200
		#assert DIVIDER==51
	#elif PIC_CLK==20000000 && BAUD==19200
		#assert DIVIDER==64
	#endif

	SPBRG=DIVIDER;
	BRGH=HIGH_SPEED;	                        //data rate for sending
	SYNC=0;						//asynchronous
	SPEN=1;						//enable serial port pins
	CREN=0;						//enable reception
	SREN=0;						//no effect
	TXIE=0;						//disable tx interrupts
	RCIE=0;						//enable rx interrupts
	TX9=0;						//8-bit transmission
	RX9=0;						//8-bit reception
	TXEN=0;						//reset transmitter
	TXEN=1;						//enable the transmitter
}

unsigned char dummy;


#define clear_usart_errors_inline	\
if (OERR)				\
{                                       \
        TXEN=0;				\
	TXEN=1;				\
	CREN=0;				\
	CREN=1;                         \
}					\
if (FERR)				\
{					\
	dummy=RCREG;			\
	TXEN=0;				\
	TXEN=1;				\
}

//writes a character to the serial port
void putch(unsigned char c)
{
	while(!TXIF)			//set when register is empty
	continue;
	TXREG=c;
	
}

//gets a character from the serial port without timeout
unsigned char getch(void)
{
	while(!RCIF)
	continue;
	return RCREG;
        
}


 
//Get string until CR
unsigned char gets_string_until_cr(char *buffer)
 {

    unsigned char data;

   do
   {
     RX_RS232_timeout = RX_RS232_timeout_value; //Remet le timeout en fonction
     data = getch_timeout();                    //Get a character from the USART

     data = *buffer;                            //and save in the string
     buffer++;                                  //Increment the string pointer
     


   }while(data != 0x0D); ////Retrieve characters until CR                           
   
 
   return data;

 }
 
 
 unsigned char getch_timeout(void)

{
     //Wait for RX bytes and timeout if too long
    while((RX_RS232_timeout >= 1) && (!RCIF))

    {

     RX_RS232_timeout --;
     clear_usart_errors_inline;
    
    }
    //indique un timeout lors de la rception
    if (RX_RS232_timeout == 0)

    {
     memset(RX_Projo_Answer, '\0', sizeof(RX_Projo_Answer) );       //Reset la dernire rponse du projecteur
     //strcpy(RX_Projo_Answer,"expire" );
    }
    return RCREG;
}

void clear_usart_errors(void)
{
clear_usart_errors_inline;
}



/*
writes a character to the serial port in hex
if serial lines are disconnected, there are no errors
*/

void putchhex(unsigned char c)
{
	unsigned char temp;

	// transmits in hex

	temp=c;

	c=(c >> 4);
	if (c<10) c+=48; else c+=55;
	putch(c);

	c=temp;

	c=(c & 0x0F);
	if (c<10) c+=48; else c+=55;
	putch(c);
    putcr;
    putlf;
}


/*
writes a character to the serial port in decimal
if serial lines are disconnected, there are no errors
*/
void putchdec(unsigned char c)
{
	unsigned char temp;

	temp=c;
	//hundreds
	if ((c/100)>0) putch((c/100)+'0');
	c-=(c/100)*100;

	//tens
	if (((temp/10)>0) || ((temp/100)>0)) putch((c/10)+'0');
	c-=(c/10)*10;

	//ones
	putch((c/1)+'0');
}





void Write_Hex_Array(const unsigned char str[])
{   
    
    
    unsigned char i;
    //Envoie les 6 bytes en hexa
    for (i = 0 ; i <= 6 ; i++)                   
	{
	
		while(!TXIF)			//set when register is empty
        continue;
        TXREG=str[i];
        
	}
    //Envoie un crlf
    //putcr;
    //putlf;
}


void putst(const char *str)
{
	while((*str)!='\0')
	{
		//Wait for TXREG Buffer to become available
		while(!TXIF);
                clear_usart_errors_inline;
		//Write data
		TXREG=(*str);

		//Next goto char
		str++;
	}
}

void tx_command_tv(const char *str)
{
	unsigned char i = 0;
    while(i <= 6)
	{
		//Wait for TXREG Buffer to become available
		while(!TXIF);
         //       clear_usart_errors_inline;
		//Write data
		TXREG=(*str);

		//Next goto char
		str++;
        i ++;
	}
}

/*
Writes a line of text to USART and send carriage return (CR)
*/

void USARTWriteLine(const char *ln)
{

    putst(ln);
    putcr;
    putlf;
           
}


void gets_string(unsigned char len)

 {
  
   
   unsigned char i;                             //Length counter
   
   for(i=0;i<len;i++)                           //Only retrieve len characters
   {

     RX_RS232_timeout = RX_RS232_timeout_value; //Remet le timeout en fonction
     RX_Projo_Answer[i] = getch_timeout();     //Get a character from the USART
     
   }
    

    RX_flag=1;
    
}




